<?php

namespace App\Http\Controllers;

use App\Models\Addon;
use Illuminate\Http\Request;

class AddonController extends Controller
{
    /**
     * Addon list
     * 
     * @return view
     */
    public function index()
    {
        $addons = Addon::orderBy('id', 'DESC')->paginate(10);

        return view('addon.index', ['addons' => $addons]);
    }

    /**
     * Create view
     * 
     * @return view
     */
    public function create()
    {
        return view('addon.create');
    }

    /**
     * Addon create 
     * 
     * @param $request
     * @return view
     */
    public function postCreate(Request $request)
    {
        $input = $request->all();

        $input['merchant_site_id'] = auth('web')->user()->id;

        Addon::create($input);

        return redirect()->to('addon/index')->withSuccess('Addon create successfuly');
    }

    /**
     * Addon edit by id
     * 
     * @return view
     */
    public function edit($id)
    {
        $addons = Addon::find($id);

        return view('addon/edit', ['addons' => $addons]);
    }

    /**
     * Addon update
     * 
     * @param by id
     * @param $request
     * 
     * @return view
     */
    public function update(Request $request, $id)
    {
        $id = $request->id;
        
        $input = $request->all();

        $input['merchant_site_id'] = auth('web')->user()->id;

        Addon::find($id)->update($input);

        return redirect()->to('addon/index')->withSuccess('Update successfuly');
    }

    /**
     * Addon delete
     * 
     * @param by id
     * @return view
     */
    public function delete($id)
    {
        $addons = Addon::find($id);
        $addons->delete();

        return redirect()->to('addon/index')->withSuccess('Delete successfuly');
    }
}
