<?php
namespace App\Http\Helpers;


class Helper
{
    /**
     * Json response helper
     *
     * @param $data
     * @param int $code
     * @param string[] $messages
     * @param array $extra
     * @return \Illuminate\Http\JsonResponse
     */
    public static function responseHelper(
        $data, $code = 200, $messages = ["Request Completed Successfully"], $extra = []
    ): \Illuminate\Http\JsonResponse
    {
        $response = [
            "code" => $code,
            "messages" => $messages
        ];

        $response['data'] = [];

        if($code >= 200 && $data ) {
            if( isset($data['pagination']) && $data['pagination'] ){
                $response['data'] = $data['data'];
                $response['pagination'] = $data['pagination'];
            } else {
                $response['data'] = $data;
            }
        }

        if( $code > 400 ) {
            return response()->json(['error' => $response], $code);
        } else {
            return response()->json(['response' => array_merge(
                $response,
                $extra
            )], $code);
        }
    }

}
