<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Addon extends Model
{
    use HasFactory, SoftDeletes;

    /**
    * The attributes that are mass assignable.
    *
    * @var string[]
    */
    protected $fillable = [
        'merchant_site_id',
        'name',
        'price'
    ];

    /**
    * Retrieve merchant belongs to the merchant site
    *
    * @return BelongsTo
    */
    public function merchant()
    {
        return $this->belongsTo(Merchant::class);
    }

    /**
    * Retrieve menu belongs to the menu addon
    *
    * @return BelongsTo
    */
    public function menuAddon()
    {
        return $this->belongsTo(MenuAddon::class);
    }

    /**
    * Retrieve menu belongs to the  menu attribute
    *
    * @return BelongsTo
    */
    public function menuAttribute()
    {
        return $this->belongsTo(MenuAttribute::class);
    }
}
