<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuAttribute extends Model
{
    use HasFactory;

    /**
    * The attributes that are mass assignable.
    *
    * @var string[]
    */
    protected $fillable = [
        'menu_id',
        'attribute_id',
    ];

    public function option(){
        
        return $this->belongsTo( Attribute::class, 'attribute_id' );
    }

    public function attributeValues(){

        return $this->hasMany( MenuAttributeValue::class );
    }
}
