<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MerchantSite extends Model
{
    use HasFactory;

    protected $fillable = [
        'merchant_id',
        'name',
        'site_status',
        'is_online',
        'phone',
        'address',
        'city',
        'state',
        'zip',
        'country',
        'business_type',
        'image',
        'cover_image',
        'min_order_amount',
        'min_cook_time',
        'price_range',
        'food_type',
        'description'
    ];

    public function merchant()
    {
        return $this->belongsTo(Merchant::class);
    }

    //merchant site document
    public function merchantSiteDocument()
    {
        return $this->hasMany(MerchantSiteDocument::class);
    }
}
