<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            //is_admin is a boolean field that is used to determine if the user is admin or not.
           // $table->boolean('is_admin')->default(false);
            //is_active is a boolean field that is used to determine if the user is active or not.
            $table->boolean('is_active')->default(true);
            $table->rememberToken();
            //last_login is a timestamp field that is used to determine the last time the user logged in.
            $table->timestamp('last_login')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
