<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMerchantSitesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('merchant_sites', function (Blueprint $table) {
            $table->id();
            $table->foreignId('merchant_id')->constrained();
            $table->string('name');
            //site status active/pending/suspended
            $table->string('site_status')->default('pending');
            //is_online
            $table->boolean('is_online')->default(false);
            $table->string('phone')->default('');
            $table->string('address')->default('');
            $table->string('city')->default('');
            $table->string('state')->default('');
            $table->string('zip');
            $table->string('country')->default('US');
            $table->string('business_type')->default('');
            //image
            $table->string('image')->nullable();
            //cover image
            $table->string('cover_image')->nullable();
            //min order amount
            $table->string('min_order_amount')->nullable();
            //min cook time
            $table->string('min_cook_time')->nullable();
            //price range
            $table->string('price_range')->nullable();
            $table->string('food_type')->nullable();
            $table->longText('description')->nullable();
            $table->string('latitude')->nullable();
            $table->string('longitude')->nullable();
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('merchant_sites');
    }
}
