<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menus', function (Blueprint $table) {
            $table->id();
            $table->foreignId('menu_type_id')->nullable();
            $table->string('name')->nullable();
            $table->text('short_description')->nullable();
            $table->text('description')->nullable();
            $table->text('ingridients')->nullable();
            $table->text('calories')->nullable();
            $table->text('allergies')->nullable();
            $table->string('image')->nullable();
            $table->text('variations')->nullable();
            $table->text('choice_options')->nullable();
            // $table->string('addons')->nullable();
            $table->string('attributes',255)->nullable();
            $table->decimal('price')->default(0);
            $table->decimal('discount')->default(0);
            $table->string('discount_type',20)->default('percent');
            $table->time('available_time_starts')->nullable();
            $table->time('available_time_ends')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menus');
    }
}
