<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MerchantSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //insert merchant data
        DB::table('merchants')->insert([
            'first_name' => 'Merchant 1',
            'last_name' => 'Merchant 1',
            'email'=>'merchant1@jr.com',
            'password'=>bcrypt('12345678'),
            'phone'=>'1234567890',
            'is_active'=>true,
            'created_at'=>now(),
            'updated_at'=>now(),


        ]);
        DB::table('merchant_sites')->insert([
            'merchant_id' => 1,
            'name' => 'merchant 1 site ',
            'site_status' => 'active',
            'is_online'=>true,
            'phone'=>'1234567890',
            'address'=>'123 main st',
            'city'=>'city',
            'state'=>'state',
            'zip'=>'12345',
            'country'=>'USA',
            'business_type'=>'restaurant',
            'image'=>'file',
            'cover_image'=>'file',
            'min_order_amount'=>10,
            'min_cook_time'=>30,
            'price_range'=>10,
            'food_type'=>'american',
            'created_at'=>now(),
            'updated_at'=>now(),

        ]);

        //merchant site document
        DB::table('merchant_site_documents')->insert([
            'merchant_site_id' => 1,
            'title' => 'business_license',
            'document' => 'file',
            'created_at'=>now(),
            'updated_at'=>now(),

        ]);
        DB::table('merchant_site_documents')->insert([
            'merchant_site_id' => 1,
            'title' => 'certificate',
            'document' => 'file',
            'created_at'=>now(),
            'updated_at'=>now(),

        ]);
        DB::table('merchant_site_documents')->insert([
            'merchant_site_id' => 1,
            'title' => 'identity_document',
            'document' => 'file',
            'created_at'=>now(),
            'updated_at'=>now(),

        ]);
    }
}
