@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card">
            <div class="card-body"> 
            @include('layouts.alert') 
                <a href="{{ url('attribute/create') }}"
                    class="btn btn-success btn-flat"> 
                    <i class="icon-plus" aria-hidden="true"> Add Attribute</i>
                </a>
                    <hr>
                <h4 class="card-title"> Attribute List </h4>
                  <div class="table-responsive">
                    <table class="table table-hover color-table ">
                        <thead>
                            <tr>
                                <th>S.no</th>
                                <!-- <th>Merchant Site</th> -->
                                <th>Name</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($attributes as $attribute)
                            <tr>
                            <td>{{ $attribute->id }}</td>
                            <!-- <td>{{ $attribute->merchantSite->name }}</td> -->
                            <td>{{ $attribute->name }}</td>
                            <td>
                                <a href="{{ url('attribute/'.$attribute->id.'/edit') }}"
                                    class="btn btn-dropbox btn-flat btn-sm"> 
                                    <i class="icon-pencil" aria-hidden="true"></i>
                                </a>
                                <a href="{{ url('attribute/'.$attribute->id.'/delete') }}"
                                    class="btn btn-danger btn-flat btn-sm"> 
                                    <i class="icon-close" aria-hidden="true"></i>
                                </a>      
                            </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $attributes->links() }}
                   
                </div>
            </div>
    </div>

@endsection
@section('script')

@endsection