@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')

<div class="card">
    <div class="card-body">
        <!-- Nav tabs -->
        <form action="{{ url('menu/postCreate') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input">Menu Type*</label>
                <div class="col-10">
                <select name="menu_type_id" class="form-control">
                <option value="">Select Menu Type</option>
                    @foreach($menutypes as $m )
                    <option value="{{ $m->id }}">{{ ucfirst($m->name) }}</option>
                    @endforeach
                </select>
                </div>  
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input">Name*</label>
                <div class="col-10">
                <input type="text" name="name" class="form-control" autocomplete="off" placeholder=" Name" required>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Short Description*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="short_description" name="short_description"> </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Description*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="description" name="description"> </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Ingridients*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="ingridients" name="ingridients"> </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Calories*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="calories" name="calories"> </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Allergies*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="allergies" name="allergies"> </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Addon*</label>
                <div class="col-10">
                <select class="select2 m-b-10 select2-multiple" name="addon_id[]" style="width: 100%" multiple="multiple" data-placeholder="Choose" id="addon-options">
                @foreach($addons as $a )
                    <option value="{{ $a->id }}">{{ ucfirst($a->name) }}</option>
                @endforeach 
                </select>
                </div>  
            </div>
            
            <div class="border mb-4 p-2">
                <div class="form-group">
                    <label class="col-2 col-form-label" for="example-color-input"> Attribute*</label>
                    <div class="">
                    <select class="select2 m-b-10 select2-multiple" name="attribute_id[]" style="width: 100%" multiple="multiple" data-placeholder="Choose" id="attr-options">
                    @foreach($attributes as $at )
                        <option value="{{ $at->id }}">{{ ucfirst($at->name) }}</option>
                    @endforeach 
                    </select>
                </div>  
                </div>
                
                <div id="option-values"></div>

                <div id="option-multi-row"></div>

            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Price*</label>
                <div class="col-10">
                 <input type="text" name="price" autocomplete="off" class="form-control">
                </div>  
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Discount*</label>
                <div class="col-10">
                    <input type="text" name="discount" autocomplete="off" class="form-control">
                </div>      
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Discount Type*</label>
                <div class="col-10">
                <select name="discount_type" class="form-control">
                <option value="">Select Menu Type</option>
                    <option value="Percent">Percent</option>
                    <option value="Amount">Amount</option>
                </select>
                </div> 
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Time Starts*</label>
                <div class="col-10">
                <input type="time" name="available_time_starts" autocomplete="off" class="form-control">
                </div>   
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Time Ends*</label>
                <div class="col-10">
                <input type="time" name="available_time_ends" autocomplete="off" class="form-control">
                </div>
            </div> 
            
            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Image*</label>
                <div class="col-10">
                <input type="file" name="image" class="form-control">
                </div>   
            </div> 

            <div class="mt-2 text-right">
                <button class="btn btn-warning">Save</button>
            </div>

        </form>
    </div>
</div>
@endsection

@section('script')

<script>

    CKEDITOR.editorConfig = function(config) {
        config.language = 'es';
        config.uiColor = '#F7B42C';
        config.height = 2000;
        config.toolbarCanCollapse = true;
    };

    $("#addon-options").select2();
    $("#attr-options").select2();

    $('#attr-options').on('select2:unselecting', function (e) {
        var data = e.params.args.data;
        console.log(data, e);

        $(`#${ data.text }-${ data.id }`).remove()

    });

    $('#attr-options').on('select2:select', function (e) {
        var data = e.params.data;
        console.log(data);

        $("#option-values").append( `
            <div class="mb-4 p-2" id="${ data.text +"-"+ data.id  }" >
                <div>
                    <label>${ data.text }</label>
                    <button onclick="addRow('#${ data.text +"-"+ data.id  }', ${data.id})" class="btn btn-warning btn-sm"  type="button"><i class="icon-plus"></i></button>
                </div>
                <div class="row mb-2">
                    <div class="col-sm-4">
                        <input type="text" name="attribute[${data.id}][0][description]" class="form-control" placeholder="Option">
                    </div>
                    <div class="col-sm-4">
                        <input type="number" name="attribute[${data.id}][0][price]" class="form-control" placeholder="Price">
                    </div>
                    <div class="col-sm-4">
                        <button type="button" onclick="removeRow(this)" class="btn btn-danger"><i class="ti-trash"></i></button>
                    </div>
                </div>
            </div>` );
    });

    function addRow(elem, id){

        var index = $(elem).find('.row').length;

        $(elem).append(`
        <div class="row mb-2">
            <div class="col-sm-4">
                <input type="text" name="attribute[${ id }][${index}][description]" class="form-control" placeholder="Option">
            </div>
            <div class="col-sm-4">
                <input type="number" name="attribute[${ id }][${index}][price]" class="form-control" placeholder="Price">
            </div>
            <div class="col-sm-4">
                <button type="button" onclick="removeRow(this)" class="btn btn-danger"><i class="ti-trash"></i></button>
            </div>
        </div>`);
    }

    function removeRow(elem){
        $(elem).parent().parent().remove();
        // $(elem)
    }

</script>
@endsection