@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="card">
    <div class="card-body">
        <h4 class="card-title"> Filter</h4>
        <hr>
        <!-- Nav tabs -->
        <form action="">
            <div class="row">
                <div class="col-sm-6">
                    <input type="text" name="name" class="form-control" autocomplete="off" placeholder=" Menu Name">
                </div>
                <div class="mt-0">
                <button class="btn btn-warning">Search</button>
                </div>
            </div>
            
        </form>
    </div>
</div>

<div class="card">
    <div class="card-body">
        @include('layouts.alert')
        <a href="{{ url('menu/create') }}" class="btn btn-warning btn-flat">
            <i class="icon-plus" aria-hidden="true"> Add Menu</i>
        </a>
        <hr>
        <h4 class="card-title"> Menu List </h4>
        <div class="table-responsive">
            <table class="table table-hover color-table ">
                <thead>
                    <tr>
                        <th>S.no</th>
                        <th>Menu Type</th>
                        <th>Name</th>
                        <th>Image</th>
                        <th>Price</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($menus as $menu)
                    <tr>
                        <td>{{ $menu->id }}</td>
                        <td>{{ @$menu->menuType->name }}</td>
                        <td>{{ @$menu->name }}</td>
                        <td> <img src="{{ url('storage/'.$menu->image ) }}" style="width: 120px; height: 100px;"> </td>
                        <td>{{ $menu->price }}</td>
                        <td>
                            <input data-id="{{ $menu->id }}" class="toggle-class success" type="checkbox"
                             data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" 
                             data-off="InActive" {{ $menu->status ? 'checked' : '' }}>
                        </td>
                        <!-- <td>{{ $menu->merchant_site_id }}</td> -->
                        <td>
                            <a href="{{ url('menu/'.$menu->id.'/edit') }}" class="btn btn-dropbox btn-flat btn-sm">
                                <i class="icon-pencil" aria-hidden="true"></i>
                            </a>

                            <a href="{{ url('menu/'.$menu->id.'/delete') }}" class="btn btn-danger btn-flat btn-sm">
                                <i class="icon-close" aria-hidden="true"></i>
                            </a>

                            <a href="{{ url('menu/'.$menu->id.'/view') }}" class="btn btn-success btn-flat btn-sm">
                                <i class="icon-eye" aria-hidden="true"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {{ $menus->links() }}
        </div>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(function() {
        $('.toggle-class').change(function() {
            var status = $(this).prop('checked') == true ? 1 : 0;
            var id = $(this).data('id');
            console.log(status);
            $.ajax({
                type: "get",
                dataType: "json",
                url: "{{ url('menu/statusUpdate') }}/ " + id,
                data: {
                    'status': status,
                    'id': id
                },
                success: function(data) {
                    sweetAlert("Updated successfully", "", "success");
                }
            });
        })
    })
</script>
@endsection