@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card">
            <div class="card-body"> 
            @include('layouts.alert')  
                <a href="{{ url('menutype/create') }}"
                    class="btn btn-success btn-flat"> 
                    <i class="icon-plus" aria-hidden="true"> Add Type Menu</i>
                </a>
                    <hr>
                <h4 class="card-title"> Menu Type List </h4>
                  <div class="table-responsive">
                    <table class="table table-hover color-table ">
                        <thead>
                            <tr>
                                <th>S.no</th>
                                <th>Merchant Site</th>
                                <th>Name</th>
                                <th>Position</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($menutypes as $menu)
                            <tr>
                            <td>{{ $menu->id }}</td>
                            <td>{{ $menu->merchantSite->name }}</td>
                            <td>{{ $menu->name }}</td>
                            <td>{{ $menu->position }}</td>
                            <td>
                                <input data-id="{{ $menu->id }}"  class="toggle-class success" type="checkbox" 
                                    data-onstyle="success" data-offstyle="danger" data-toggle="toggle" 
                                    data-on="Active" data-off="InActive" {{ $menu->status ? 'checked' : '' }}>
                            </td>
                            <!-- <td>{{ $menu->merchant_site_id }}</td> -->
                            <td>
                                <a href="{{ url('menutype/'.$menu->id.'/edit') }}"
                                    class="btn btn-dropbox btn-flat btn-sm"> 
                                    <i class="icon-pencil" aria-hidden="true"></i></a>
                                <button class="btn btn-danger btn-flat btn-sm "
                                    onclick="deleteConfirmation('{{ $menu->id }}')">
                                    <i class="icon-close" aria-hidden="true"></i>
                                </button>    
                            </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $menutypes->links() }}
                   
                </div>
            </div>
    </div>

@endsection
@section('script')

<script type="text/javascript">

    $(function() {
    $('.toggle-class').change(function() {
        var status = $(this).prop('checked') == true ? 1 : 0; 
        var id = $(this).data('id'); 
         console.log(status);
        $.ajax({
            type: "get",
            dataType: "json",
            url: "{{ url('menutype/statusUpdate') }}/ " + id,
            data: {'status': status, 'id': id},
            success: function(data) {    
             sweetAlert("Updated successfully", "", "success");
           }
        });
    })
  })

</script>
@endsection