@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')
<div class="row">
    <div class="col-lg-4 col-xlg-3 col-md-5">
        <div class="card"> 
            <div class="card-body">
            @include('layouts.alert')
            <h3 class="m-t-0"> My Restaurant</h3>

            <div style="margin-top: -40px; margin-left: 230px;">
                    <a href="{{ url('merchant-site/edit') }}" class="btn btn-dropbox btn-flat ">
                    <i class="icon-pencil" aria-hidden="true"> Edit</i></a>
            </div>
             <hr>    
         
            <div class="user-bg"> <img width="100%" src="{{ url('storage/merchant_site/'.$merchants->image ) }}"> </div>
                <div class="user-btm-box">
                    <!-- .row -->
                    <div class="row text-center m-t-10">
                        <div class="col-md-6 b-r"><strong style="font-weight: bold;"> Name</strong>
                            <p>{{ $merchants->name }} </p>
                        </div>

                        <div class="col-md-6 b-r"><strong style="font-weight: bold;"> Phone</strong>
                             <p>{{ $merchants->phone }} </p>
                        </div>

                        <div class="col-md-6 b-r"><strong style="font-weight: bold;"> Address</strong>
                             <p>{{ $merchants->address }} </p>
                        </div>

                        <div class="col-md-6 b-r"><strong style="font-weight: bold;"> Country</strong>
                             <p>{{ $merchants->country }} </p>
                        </div>

                        <div class="col-md-6 b-r"><strong style="font-weight: bold;"> Business Type</strong>
                             <p>{{ $merchants->business_type }} </p>
                        </div>
                    </div> 
                </div>
                
            </div>
        </div>
    </div>

    <!-- Column -->
    <div class="col-lg-8 col-xlg-9 col-md-7">
        <div class="card">
            <div class="card-body">
                <h3 class="m-t-0"> My Restaurant</h3>

                <div class="btn btn-warning" style="margin-top: -31px; margin-left: 482px; font-weight: 600;">
                <input data-id="{{ $merchants->id }}" class="toggle-class success" type="checkbox"
                        data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" 
                        data-off="InActive" {{ $merchants->is_online ? 'checked' : '' }}> Restaurants On/Off  
                </div>
                <hr>

                <div class="row">
                    <div class="col-xs-6 b-r" style="max-height: 250px; overflow-y: hidden;"> <strong style="font-weight: bold;"> Cover Photo: </strong>
                        <br>
                        <img width="100%" src="{{ url('storage/merchant_site/'.$merchants->cover_image ) }}">  
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>    
@endsection


@section('script')

<script type="text/javascript">
    $(function() {
        $('.toggle-class').change(function() {
            var is_online = $(this).prop('checked') == true ? 1 : 0;
            var id = $(this).data('id');
            console.log(is_online);
            $.ajax({
                type: "get",
                dataType: "json",
                url: "{{ url('merchant-site/toggleUpdate') }}/" + id,
                data: {
                    'is_online': is_online,
                    'id': id
                },
                success: function(data) {
                    sweetAlert("Updated successfully", "", "success");
                }
            });
        })
    })
</script>
@endsection