<?php

use App\Http\Controllers\AddonController;
use App\Http\Controllers\AttributeController;
use App\Http\Controllers\ChangePasswordController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\MenuTypeController;
use App\Http\Controllers\MerchantSiteController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\TimeManageController;
use App\Models\Menu;
use App\Models\MerchantSite;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

//Change Password
Route::get('setting/credential', [ChangePasswordController::class, 'create']);
Route::patch('setting/store',  [ChangePasswordController::class, 'store']);

//Menu Type
Route::get('menutype/index', [MenuTypeController::class, 'index']);
Route::get('menutype/create', [MenuTypeController::class, 'create']);
Route::post('menutype/postCreate', [MenuTypeController::class, 'postCreate']);
Route::get('menutype/{id}/edit', [MenuTypeController::class, 'edit']);
Route::post('menutype/{id}/update', [MenuTypeController::class, 'update']);
Route::post('menutype/{id}/delete', [MenuTypeController::class, 'delete']);
Route::get('menutype/statusUpdate/{id}', [MenuTypeController::class, 'statusUpdate']);

//Menu
Route::get('menu/index', [MenuController::class, 'index']);
Route::get('menu/create', [MenuController::class, 'create']);
Route::post('menu/postCreate', [MenuController::class, 'postCreate']);
Route::get('menu/{id}/edit', [MenuController::class, 'edit']);
Route::post('menu/{id}/update', [MenuController::class, 'update']);
Route::get('menu/{id}/delete', [MenuController::class, 'delete']);
Route::get('menu/statusUpdate/{id}', [MenuController::class, 'statusUpdate']);
Route::get('menu/{id}/view', [MenuController::class, 'view']);

//Addons
Route::get('addon/index', [AddonController::class, 'index']);
Route::get('addon/create', [AddonController::class, 'create']);
Route::post('addon/postCreate', [AddonController::class, 'postCreate']);
Route::get('addon/{id}/edit', [AddonController::class, 'edit']);
Route::post('addon/{id}/update', [AddonController::class, 'update']);
Route::get('addon/{id}/delete', [AddonController::class, 'delete']);

//Merchant Site
Route::get('merchant-site/index', [MerchantSiteController::class, 'index']);
Route::get('merchant-site/edit', [MerchantSiteController::class, 'edit']);
Route::post('merchant-site/{id}/update', [MerchantSiteController::class, 'update']);
Route::get('merchant-site/toggleUpdate/{id}', [MerchantSiteController::class, 'toggleUpdate']);

//Attributes
Route::get('attribute/index', [AttributeController::class, 'index']);
Route::get('attribute/create', [AttributeController::class, 'create']);
Route::post('attribute/postCreate', [AttributeController::class, 'postCreate']);
Route::get('attribute/{id}/edit', [AttributeController::class, 'edit']);
Route::post('attribute/{id}/update', [AttributeController::class, 'update']);
Route::get('attribute/{id}/delete', [AttributeController::class, 'delete']);

//Order
Route::get('order/index',[OrderController::class, 'index']);
Route::get('order/view',[OrderController::class, 'view']);
Route::get('order/edit',[OrderController::class, 'edit']);

//Shop time Manage
Route::get('shop/edit', [TimeManageController::class, 'edit']);
Route::post('shop/{id}/update', [TimeManageController::class, 'update']);

















